function [] = crawltxtnames(varargin)
%This function is designed to crawl through a directory structure of
%centroid files and write out a file that contains the name and the number 
%of centroids found. (Strictly experimental for now)
%Synatax:   [] = crawltxtnames()
%Input:     no inputs, you will be prompted
%Output:    none

[dirname] = parse(varargin);

%now grab those directory names
dir_struct = dir(dirname);  %grab the directory information
idx = [dir_struct.isdir];   %grab all of the isdir numbers
idx(1:2) = 0;               %remove the first two directories
dirnames = {dir_struct.name};   %grab the all of the names in the root
dirnames = dirnames(idx);  %don't want the first two
dir_tmp = repmat([dirname filesep],size(dirnames'));    %replicated the directory name for appending
dirnames = cellstr([dir_tmp char(dirnames')]);      %now each cell contains the full directory path

if ~isempty(dirnames)   %if the root only have files, then no need to go further
    while 1     %we are going to dig until all sub_dirs are found
        dir_tmp = [];   %clear!
        dir_end = 0;    %reset
        out_tmp = [];
        %level in
        for i = 1:size(dirnames,1)  %for each dir_step down one
            curr_dir = dirnames{i};     %current directory
            dir_info = dir(curr_dir); %grab the current dir
            idx = [dir_info.isdir];   %grab all of the isdir numbers
            curr_names = {dir_info.name};   %grab the all dir content
            filenames = curr_names(~idx);   %grab the files first
            idx(1:2) = 0;   %toss the first two
            dir_nxt = curr_names(idx);    %the interesting directories
            
            %for every directory see if there are csvs around that fit the
            %desired criteria
            filenames = findfiletype(filenames,'.csv');  %only csvs for now
            if ~isempty(filenames)  %found csv files
                mxlabel = {};   %initiate
                cdata = [];
                %parse filenames
                for j = 1:size(filenames,2)
                    %create file label
                    typeidx = strfind(filenames{j},' ');
                    try     %if we meet any files that don't fit skip.
                        %label_tmp = filenames{j}(1:typeidx(1)-1);
                        if size(typeidx,2)==2 %two spaces for files like '1 DAPI 350.xxx.csv'
                            label_tmp = filenames{j}(typeidx(1)+1:typeidx(2)-1);
                        elseif size(typeidx,2)==1 %one space just in case for 'DAPI 350.xxx.csv'
                            label_tmp = filenames{j}(1:typeidx(1)-1);
                        else %no spaces for cases like FMRPnuc.xxx.csv
                            typeidx = strfind(filenames{j},'.');
                            label_tmp = filenames{j}(1:typeidx(1)-1);
                        end
                        %now lets make sure there are no duplicate labels
                        if max(strcmpi(mxlabel,label_tmp))
                            label_tmp = [label_tmp, num2str(sum(strncmpi(mxlabel,label_tmp,size(label_tmp,2)))+1)];
                        end
                        mxlabel = [mxlabel label_tmp];
                        %read centroid number
                        dataidx = strfind(filenames{j},'.');
                        cdata = [cdata str2num(filenames{j}(dataidx(1)+1:dataidx(2)-1))];
                    catch
                        warning(['File: ',[curr_dir,filesep,filenames{j}],' is not recognized.']);
                    end
                end
                %now write out the file
                if ~isempty(cdata)
                    data_exp = dataset({cdata,mxlabel{:}});
                    export(data_exp,'File',[curr_dir,filesep,'CentroidNumber.csv'],'delimiter',',')
                end
            end
            
            %iterate on
            if isempty(dir_nxt)   %bottom
                dir_end = dir_end+1;    %one path to its conclusion
            else    %not the bottom
                curr_dir = repmat([curr_dir filesep],size(dir_nxt'));    %replicated the directory name for appending
                dir_tmp = vertcat(dir_tmp,cellstr([curr_dir char(dir_nxt')]));      %now each cell contains the full directory path
            end
        end
        if dir_end==size(dirnames,1)    %all directories are at an end
            break
        else    %move next level down
            dirnames = dir_tmp;
        end
    end
end

%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [dirname] = parse(input)

dirname = [];

%Parse the input
if ~isempty(input)
    for i = 1:2:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'dirname'
                    dirname = input{1,i+1};
                otherwise
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        else
            error(['The parameters you entered is incorrect.  Please check help.']);
        end
    end
end

%Get the location of the images you want to open
if isempty(dirname)
    dirname = uigetdir2('','Directory where your images are');    %get the directory
end